/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.properties;

import com.aptana.ui.epl.UIEplPlugin;
import com.aptana.ui.properties.EplMessages;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.internal.OverlayIcon;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NaturesLabelProvider
extends LabelProvider
implements IFontProvider {
    private static final ImageDescriptor APTANA_NATURE_IMAGE = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.aptana.ui.epl", (String)"icons/aptana_nature.gif");
    private static final ImageDescriptor EMPTY_IMAGE = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.aptana.ui.epl", (String)"icons/transparent_16x16.png");
    private Map<String, String> fNatureDescriptions;
    private String fPrimaryNature;

    public NaturesLabelProvider(Map<String, String> natureDescriptions) {
        this.fNatureDescriptions = natureDescriptions;
    }

    public String getText(Object element) {
        String description = this.fNatureDescriptions.get(element.toString());
        if (description == null) {
            return "";
        }
        if (this.isPrimary(element.toString())) {
            description = String.valueOf(description) + EplMessages.ProjectNaturesPage_LBL_Primary;
        }
        return description;
    }

    public Image getImage(Object element) {
        String nature = element.toString();
        CenterIcon oi = null;
        ImageData id = EMPTY_IMAGE.getImageData();
        try {
            ImageDescriptor d = IDEWorkbenchPlugin.getDefault().getProjectImageRegistry().getNatureImage(element.toString());
            oi = new CenterIcon(EMPTY_IMAGE, d, new Point(id.width, id.height));
        }
        catch (Exception e) {
            oi = new CenterIcon(EMPTY_IMAGE, APTANA_NATURE_IMAGE, new Point(id.width, id.height));
        }
        if (UIEplPlugin.getDefault().getImageRegistry().get(nature) == null && oi != null) {
            UIEplPlugin.getDefault().getImageRegistry().put(nature, oi.createImage());
        }
        return UIEplPlugin.getDefault().getImageRegistry().get(nature);
    }

    public Font getFont(Object element) {
        return this.isPrimary(element.toString()) ? JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont") : null;
    }

    public void setPrimaryNature(String primary) {
        this.fPrimaryNature = primary;
    }

    private boolean isPrimary(String nature) {
        return this.fPrimaryNature != null && this.fPrimaryNature.equals(nature);
    }

    private static class CenterIcon
    extends OverlayIcon {
        public CenterIcon(ImageDescriptor base, ImageDescriptor overlay, Point size) {
            super(base, overlay, size);
        }

        protected void drawTopRight(ImageDescriptor overlay) {
            if (overlay == null) {
                return;
            }
            int x = this.getSize().x / 2;
            int y = this.getSize().y / 2;
            ImageData id = overlay.getImageData();
            this.drawImage(id, x -= id.width / 2, y -= id.height / 2);
        }
    }
}

